<?php
declare(strict_types=1);

require_once APP_PATH . "/services/AdminConfigService.php";

class AdminConfigController extends Controller {

  private function requireAdmin(): void {
    Auth::requireLogin();
    $u = Auth::user();
    if (($u['rol'] ?? '') !== 'ADMIN') {
      http_response_code(403);
      echo "403 - No autorizado";
      exit;
    }
  }

  public function index(): void {
    $this->requireAdmin();
    $service = new AdminConfigService();

    $this->view('admin/config/index', [
      'configs' => $service->listar(),
      'ok' => $_GET['ok'] ?? '',
      'error' => $_GET['error'] ?? ''
    ]);
  }

  public function save(): void {
    $this->requireAdmin();
    try {
      $service = new AdminConfigService();
      $service->guardar($_POST);
      $this->redirect('/SEIR/public/admin/config?ok=' . urlencode('Configuración guardada.'));
    } catch (Throwable $e) {
      $this->redirect('/SEIR/public/admin/config?error=' . urlencode($e->getMessage()));
    }
  }
}
