<?php
declare(strict_types=1);

require_once APP_PATH . "/services/AdminComputadoraService.php";

class AdminComputadoraController extends Controller {

  private function requireAdmin(): void {
    Auth::requireLogin();
    $u = Auth::user();
    $rol = strtoupper(trim((string)($u['rol'] ?? '')));
    // Tolerante con variantes
    if (!in_array($rol, ['ADMIN','ADMINISTRADOR'], true)) {
      http_response_code(403);
      echo "403 - No autorizado";
      exit;
    }
  }

  public function index(): void {
    $this->requireAdmin();
    $service = new AdminComputadoraService();
    $this->view('admin/computadoras/index', [
      'pcs' => $service->listar(),
      'ok' => $_GET['ok'] ?? '',
      'error' => $_GET['error'] ?? ''
    ]);
  }

  public function create(): void {
    $this->requireAdmin();
    try {
      $codigo = (string)($_POST['codigo'] ?? '');
      $ip = isset($_POST['ip']) ? (string)$_POST['ip'] : null;
      $descripcion = isset($_POST['descripcion']) ? (string)$_POST['descripcion'] : null;

      $service = new AdminComputadoraService();
      $service->crear($codigo, $ip, $descripcion);

      $this->redirect('/SEIR/public/admin/computadoras?ok=' . urlencode('Computadora registrada.'));
    } catch (Throwable $e) {
      $this->redirect('/SEIR/public/admin/computadoras?error=' . urlencode($e->getMessage()));
    }
  }

  public function delete(): void {
    $this->requireAdmin();
    try {
      $id = (int)($_POST['id_computadora'] ?? 0);
      $service = new AdminComputadoraService();
      $service->eliminar($id);
      $this->redirect('/SEIR/public/admin/computadoras?ok=' . urlencode('Computadora eliminada.'));
    } catch (Throwable $e) {
      $this->redirect('/SEIR/public/admin/computadoras?error=' . urlencode($e->getMessage()));
    }
  }

  public function editForm(): void {
    $this->requireAdmin();
    $id = (int)($_GET['id'] ?? 0);
    try {
      $service = new AdminComputadoraService();
      $pc = $service->obtener($id);
      $this->view('admin/computadoras/edit', [
        'pc' => $pc,
        'error' => $_GET['error'] ?? ''
      ]);
    } catch (Throwable $e) {
      $this->redirect('/SEIR/public/admin/computadoras?error=' . urlencode($e->getMessage()));
    }
  }

  public function update(): void {
    $this->requireAdmin();
    $id = (int)($_POST['id_computadora'] ?? 0);
    try {
      $codigo = (string)($_POST['codigo'] ?? '');
      $ip = isset($_POST['ip']) ? (string)$_POST['ip'] : null;
      $descripcion = isset($_POST['descripcion']) ? (string)$_POST['descripcion'] : null;

      $service = new AdminComputadoraService();
      $service->actualizar($id, $codigo, $ip, $descripcion);
      $this->redirect('/SEIR/public/admin/computadoras?ok=' . urlencode('Computadora actualizada.'));
    } catch (Throwable $e) {
      $this->redirect('/SEIR/public/admin/computadoras/editar?id=' . $id . '&error=' . urlencode($e->getMessage()));
    }
  }

  public function toggleEstado(): void {
    $this->requireAdmin();
    $this->redirect('/SEIR/public/admin/computadoras?error=' . urlencode('Estado manual deshabilitado (se calcula por actividad real).'));
  }

  public function pingNow(): void {
    $this->requireAdmin();
    $this->redirect('/SEIR/public/admin/computadoras?error=' . urlencode('Ping manual deshabilitado (se calcula por actividad real).'));
  }
}
