-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Servidor: 127.0.0.1
-- Tiempo de generación: 19-01-2026 a las 00:20:36
-- Versión del servidor: 10.4.32-MariaDB
-- Versión de PHP: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `seir`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `administrador`
--

CREATE TABLE `administrador` (
  `id_usuario` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `administrador`
--

INSERT INTO `administrador` (`id_usuario`) VALUES
(8);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `alternativa`
--

CREATE TABLE `alternativa` (
  `id_alternativa` int(11) NOT NULL,
  `id_pregunta` int(11) NOT NULL,
  `texto` varchar(255) NOT NULL,
  `es_correcta` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `alternativa`
--

INSERT INTO `alternativa` (`id_alternativa`, `id_pregunta`, `texto`, `es_correcta`) VALUES
(17, 2, 'a', 1),
(18, 2, 'b', 0),
(19, 2, 'c', 0),
(20, 2, 'd', 0),
(21, 3, 'e', 1),
(22, 3, 'b', 0),
(23, 3, 'c', 0),
(24, 3, 'd', 0),
(29, 4, 'r', 0),
(30, 4, 'i', 1),
(31, 4, 'x', 0),
(32, 4, 'm', 0),
(33, 5, '4', 0),
(34, 5, 'nose', 0),
(35, 5, 'mañana es mañana', 1),
(36, 5, 'ayer', 0),
(37, 6, 'el 7', 1),
(38, 6, '4', 0),
(39, 6, '1', 0),
(40, 6, '2', 0),
(41, 7, 'E', 0),
(42, 7, 'EE', 0),
(43, 7, 'EEEEEEEE', 0),
(44, 7, 'EEEEEEEEEEEEEE', 1),
(45, 8, 'WWWWWWWW', 0),
(46, 8, 'WWWWWWWWWWWWWWWWWW', 0),
(47, 8, 'WWWWWWWWWWWWWWWWW', 0),
(48, 8, 'WWWWWWWWWWWWWWWWWWWWWWWWWWW', 1),
(49, 9, 'a', 0),
(50, 9, 'aaa', 0),
(51, 9, 'aaaaaa', 0),
(52, 9, 'aaaaaaaaaaaa', 1),
(53, 10, 'e', 0),
(54, 10, 'eeeee', 0),
(55, 10, 'eeeeeeeeeeeeeeeee', 0),
(56, 10, 'eeeeeeeeeeeeeeeeeeeeeeeeeeeeee', 1),
(57, 11, 'gaaa', 0),
(58, 11, 'gaaaaaaaaaaaaa', 0),
(59, 11, 'agaaaaaaaaaaaaaaaaaaaaaaaa', 0),
(60, 11, 'aaagAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA', 1),
(61, 12, 'XDD', 0),
(62, 12, 'XDDDDDDDDDDDDDDDDDDDDDDDDDDDD', 1),
(63, 12, 'XDDDDDDDDDDDDDD', 0),
(64, 12, 'XDDD', 0),
(65, 13, 'F', 0),
(66, 13, 'FFFFFFF', 0),
(67, 13, 'FFFFFFFFFFFFFFFFFFFF', 0),
(68, 13, 'FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF', 1),
(69, 14, 'aaaa', 0),
(70, 14, 'aaaaaaaaaaaaa', 0),
(71, 14, 'aaaaaaaaaaaaaaaaaaaaa', 0),
(72, 14, 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa', 1),
(73, 15, 'VVVVVVVV', 0),
(74, 15, 'VVVVVVVVVVVVVVV', 0),
(75, 15, 'VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV', 1),
(76, 15, 'VVV', 0),
(77, 16, 'M', 0),
(78, 16, 'MMM', 0),
(79, 16, 'MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM', 1),
(80, 16, 'MMM', 0),
(81, 17, '1', 0),
(82, 17, '111111', 0),
(83, 17, '11111111111111111111111', 0),
(84, 17, '111111111111111111111111111111', 1),
(85, 18, '22222222222', 0),
(86, 18, '222222222222222222222', 0),
(87, 18, '2222222222222222222222222222222222222222222222222', 1),
(88, 18, '22', 0),
(97, 20, 'fffffffffffffffffff', 0),
(98, 20, 'fffffffffffff', 0),
(99, 20, 'FFFFFFFFFFFFFFFFFFFF', 0),
(100, 20, 'ff', 1),
(101, 21, 'hh', 1),
(102, 21, 'hhhhhhhhhhhh', 0),
(103, 21, 'hhhhhhhhhhhhhhhhhhhhhhhhhhhhhh', 0),
(104, 21, 'hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh', 0),
(105, 22, 'AA', 0),
(106, 22, 'A', 0),
(107, 22, 'AAAAAAAAAA', 1),
(108, 22, 'AAAA', 0),
(113, 23, 'ggg', 0),
(114, 23, 'gggggg', 1),
(115, 23, 'g', 0),
(116, 23, 'gg', 0),
(121, 24, 'aa', 0),
(122, 24, 'aaaaa', 0),
(123, 24, 'aaa', 0),
(124, 24, 'aaaaaaaaaaa', 1),
(125, 25, 'ssssssssssss', 0),
(126, 25, 'ssssssss', 0),
(127, 25, 'sssssssssssssssssssssssssssssssssss', 1),
(128, 25, 'ss', 0),
(129, 26, 'dd', 0),
(130, 26, 'dddddd', 1),
(131, 26, 'd', 0),
(132, 26, 'ddddd', 0),
(133, 27, 'SI', 0),
(134, 27, 'NO', 1),
(135, 27, 'XD', 0),
(136, 27, 'WA', 0),
(137, 28, 'SS', 0),
(138, 28, 'S', 0),
(139, 28, 'SSSSSSSSS', 1),
(140, 28, 'SSSS', 0),
(141, 29, 'a', 0),
(142, 29, 'aaa', 0),
(143, 29, 'aaaa', 0),
(144, 29, 'aaaaaaaaa', 1),
(145, 30, 'gggg', 0),
(146, 30, 'g', 0),
(147, 30, 'gg', 0),
(148, 30, 'gggggggggggg', 1);

--
-- Disparadores `alternativa`
--
DELIMITER $$
CREATE TRIGGER `trg_alt_correcta_ins` BEFORE INSERT ON `alternativa` FOR EACH ROW BEGIN
  IF NEW.es_correcta = TRUE THEN
    IF (SELECT COUNT(*) FROM alternativa
        WHERE id_pregunta = NEW.id_pregunta AND es_correcta = TRUE) > 0 THEN
      SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'Ya existe una alternativa correcta para esta pregunta.';
    END IF;
  END IF;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `trg_alt_correcta_upd` BEFORE UPDATE ON `alternativa` FOR EACH ROW BEGIN
  IF NEW.es_correcta = TRUE AND OLD.es_correcta = FALSE THEN
    IF (SELECT COUNT(*) FROM alternativa
        WHERE id_pregunta = NEW.id_pregunta AND es_correcta = TRUE) > 0 THEN
      SIGNAL SQLSTATE '45000'
        SET MESSAGE_TEXT = 'Ya existe una alternativa correcta para esta pregunta.';
    END IF;
  END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `computadora`
--

CREATE TABLE `computadora` (
  `id_computadora` int(11) NOT NULL,
  `codigo` varchar(30) NOT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `estado` varchar(20) NOT NULL DEFAULT 'ACTIVA',
  `ultimo_ping` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `id_admin_supervisor` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `computadora`
--

INSERT INTO `computadora` (`id_computadora`, `codigo`, `ip`, `descripcion`, `estado`, `ultimo_ping`, `created_at`, `id_admin_supervisor`) VALUES
(1, 'PC-01', '192.160.1.50', 'Laboratorio 1', 'ONLINE', '2026-01-10 14:02:46', '2026-01-10 13:51:47', NULL),
(2, 'PC-02', '192.160.1.52', 'Laboratorio 2', 'ONLINE', '2026-01-10 14:02:44', '2026-01-10 13:56:28', NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `configuracion`
--

CREATE TABLE `configuracion` (
  `id_config` int(11) NOT NULL,
  `parametro` varchar(80) NOT NULL,
  `valor` varchar(255) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `configuracion`
--

INSERT INTO `configuracion` (`id_config`, `parametro`, `valor`, `descripcion`, `updated_at`) VALUES
(1, 'tiempo_pregunta_default', '40', 'Tiempo por pregunta (segundos) por defecto.', '2026-01-10 18:26:57'),
(2, 'max_preguntas_partida', '10', 'Límite de preguntas por partida (para evitar partidas muy largas).', '2026-01-10 14:03:00'),
(3, 'max_intentos_unirse', '3', 'Máximo de intentos al unirse con código (anti-spam simple).', '2026-01-10 14:03:00'),
(4, 'mensaje_bienvenida', 'Bienvenido(a) a SEIR', 'Mensaje general de bienvenida en el sistema.', '2026-01-10 14:03:00'),
(5, 'preguntas_compartidas', '0', '0=Privadas por docente, 1=Permite preguntas compartidas (públicas).', '2026-01-10 14:03:00');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `curso`
--

CREATE TABLE `curso` (
  `id_curso` int(11) NOT NULL,
  `id_docente` int(11) NOT NULL,
  `nombre` varchar(120) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Volcado de datos para la tabla `curso`
--

INSERT INTO `curso` (`id_curso`, `id_docente`, `nombre`, `descripcion`, `activo`, `created_at`, `updated_at`) VALUES
(1, 9, 'Matematica', 'Temas del I bimestre', 1, '2026-01-17 15:40:33', '2026-01-17 15:40:33'),
(2, 9, 'Comunicación', NULL, 1, '2026-01-17 23:25:48', '2026-01-17 23:25:48'),
(3, 9, 'Ecología', NULL, 1, '2026-01-17 23:26:07', '2026-01-17 23:26:07'),
(4, 9, 'Personal Social', NULL, 1, '2026-01-18 00:38:28', '2026-01-18 00:38:28');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `docente`
--

CREATE TABLE `docente` (
  `id_usuario` int(11) NOT NULL,
  `especialidad` varchar(120) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `docente`
--

INSERT INTO `docente` (`id_usuario`, `especialidad`) VALUES
(2, 'Matemática'),
(9, 'comunicación');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `estudiante`
--

CREATE TABLE `estudiante` (
  `id_usuario` int(11) NOT NULL,
  `dni` varchar(20) NOT NULL,
  `grado` varchar(30) NOT NULL,
  `seccion` varchar(30) NOT NULL,
  `id_computadora` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `estudiante`
--

INSERT INTO `estudiante` (`id_usuario`, `dni`, `grado`, `seccion`, `id_computadora`) VALUES
(3, '70000001', '5to', 'A', NULL),
(4, '70000002', '5to', 'A', NULL),
(5, '72677254', '5to', 'C', NULL),
(6, '70000003', '4to', 'A', NULL),
(7, '70000004', '2do', 'B', NULL),
(10, '70000005', '2do', 'B', NULL),
(11, '70000006', '5to', 'C', NULL),
(14, '70000010', '2do', 'B', NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `participante`
--

CREATE TABLE `participante` (
  `id_participante` int(11) NOT NULL,
  `id_partida` int(11) NOT NULL,
  `id_estudiante` int(11) NOT NULL,
  `alias` varchar(60) NOT NULL,
  `fecha_union` datetime NOT NULL DEFAULT current_timestamp(),
  `finalizado` tinyint(1) NOT NULL DEFAULT 0,
  `finalizado_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `participante`
--

INSERT INTO `participante` (`id_participante`, `id_partida`, `id_estudiante`, `alias`, `fecha_union`, `finalizado`, `finalizado_at`) VALUES
(2, 1, 10, 'EST-10', '2026-01-10 23:35:13', 1, '2026-01-10 23:35:13'),
(3, 1, 4, 'EST-4', '2026-01-10 23:35:53', 1, '2026-01-10 23:35:53'),
(4, 1, 7, 'EST-7', '2026-01-10 23:37:33', 1, '2026-01-10 23:37:33'),
(5, 1, 5, 'EST-5', '2026-01-10 23:38:38', 1, '2026-01-10 23:38:38'),
(8, 5, 5, 'EST-5', '2026-01-11 17:46:24', 1, '2026-01-11 17:51:25'),
(9, 5, 3, 'EST-3', '2026-01-11 17:51:54', 1, '2026-01-11 17:51:54'),
(10, 5, 10, 'EST-10', '2026-01-11 17:53:11', 1, '2026-01-11 17:53:11'),
(12, 6, 10, 'EST-10', '2026-01-11 17:53:56', 1, '2026-01-11 17:54:24'),
(14, 7, 10, 'EST-10', '2026-01-11 18:00:32', 1, '2026-01-11 18:00:55'),
(16, 8, 5, 'EST-5', '2026-01-11 18:05:31', 0, NULL),
(17, 8, 11, 'EST-11', '2026-01-11 18:05:55', 1, '2026-01-11 18:06:28'),
(19, 9, 11, 'EST-11', '2026-01-11 18:10:22', 1, '2026-01-11 18:10:36'),
(20, 9, 5, 'EST-5', '2026-01-11 18:10:50', 1, '2026-01-11 18:14:17'),
(23, 9, 3, 'EST-3', '2026-01-11 18:15:06', 0, NULL),
(24, 9, 10, 'EST-10', '2026-01-11 18:16:14', 1, '2026-01-11 18:16:14'),
(26, 10, 10, 'EST-10', '2026-01-11 18:17:24', 1, '2026-01-11 18:17:34'),
(28, 10, 5, 'EST-5', '2026-01-11 18:23:29', 1, '2026-01-11 18:23:29'),
(32, 13, 14, 'EST-14', '2026-01-11 19:57:52', 1, '2026-01-11 19:58:04'),
(34, 14, 5, 'EST-5', '2026-01-11 19:59:25', 1, '2026-01-11 19:59:46'),
(36, 2, 5, 'aaa', '2026-01-16 11:48:17', 1, '2026-01-16 11:48:17'),
(38, 24, 5, '72677254', '2026-01-16 18:22:57', 1, '2026-01-16 18:35:38'),
(40, 25, 5, '72677254', '2026-01-16 19:11:42', 1, '2026-01-16 19:27:46'),
(42, 27, 3, '70000001', '2026-01-16 19:57:43', 1, '2026-01-16 19:58:09'),
(44, 28, 5, 'toñito', '2026-01-18 01:58:01', 0, NULL),
(46, 39, 5, 'toññños', '2026-01-18 12:38:49', 1, '2026-01-18 12:53:46'),
(48, 40, 5, 'ANTONY', '2026-01-18 12:57:30', 1, '2026-01-18 12:58:35'),
(50, 41, 5, 'ANTONY', '2026-01-18 13:01:16', 1, '2026-01-18 13:01:56'),
(52, 44, 5, 'tony', '2026-01-18 15:12:21', 1, '2026-01-18 15:13:17');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `partida`
--

CREATE TABLE `partida` (
  `id_partida` int(11) NOT NULL,
  `codigo` varchar(30) NOT NULL,
  `titulo` varchar(150) NOT NULL,
  `estado` varchar(20) NOT NULL DEFAULT 'CREADA',
  `tiempo_pregunta` int(11) NOT NULL DEFAULT 30,
  `duracion_total_min` int(11) NOT NULL DEFAULT 30,
  `modo_preguntas` enum('ORDEN','ALEATORIO') NOT NULL DEFAULT 'ORDEN',
  `modo_alternativas` enum('FIJO','ALEATORIO') NOT NULL DEFAULT 'FIJO',
  `fecha_inicio` datetime DEFAULT NULL,
  `fecha_fin` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `id_docente` int(11) NOT NULL,
  `id_curso` int(11) DEFAULT NULL,
  `grado` enum('1','2','3','4','5','TODOS') NOT NULL DEFAULT 'TODOS',
  `grado_objetivo` tinyint(4) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `partida`
--

INSERT INTO `partida` (`id_partida`, `codigo`, `titulo`, `estado`, `tiempo_pregunta`, `duracion_total_min`, `modo_preguntas`, `modo_alternativas`, `fecha_inicio`, `fecha_fin`, `created_at`, `id_docente`, `id_curso`, `grado`, `grado_objetivo`) VALUES
(1, 'SEIR-66121', 'PRUEBA FINAL 1', 'FINALIZADA', 30, 5, 'ORDEN', 'FIJO', '2026-01-10 23:28:25', '2026-01-16 12:34:25', '2026-01-10 23:26:34', 9, NULL, 'TODOS', 0),
(2, 'SEIR-59323', 'PRUEBA  FINAL 2', 'FINALIZADA', 30, 30, 'ORDEN', 'FIJO', '2026-01-10 23:41:35', '2026-01-18 03:16:45', '2026-01-10 23:39:44', 9, NULL, 'TODOS', 0),
(3, 'SEIR-29520', 'aaaaaaaaaaaaaaa', 'FINALIZADA', 30, 5, 'ORDEN', 'FIJO', '2026-01-18 03:32:54', '2026-01-18 03:32:58', '2026-01-11 00:43:50', 9, NULL, 'TODOS', 0),
(5, 'SEIR-27460', 'PRUEBA FINAL 2', 'FINALIZADA', 30, 5, 'ORDEN', 'FIJO', '2026-01-11 17:46:24', '2026-01-11 17:57:16', '2026-01-11 17:45:30', 2, NULL, 'TODOS', 0),
(6, 'SEIR-88390', 'PRUEBA FINAL 3', 'FINALIZADA', 30, 10, 'ORDEN', 'FIJO', '2026-01-11 17:53:55', '2026-01-11 17:57:14', '2026-01-11 17:53:30', 2, NULL, 'TODOS', 0),
(7, 'SEIR-13597', 'PRUEBA FINAL 4', 'FINALIZADA', 30, 3, 'ORDEN', 'FIJO', '2026-01-11 18:00:31', '2026-01-11 18:01:22', '2026-01-11 18:00:07', 2, NULL, 'TODOS', 0),
(8, 'SEIR-53086', 'PRUEBA FINAL 5', 'FINALIZADA', 30, 5, 'ORDEN', 'FIJO', '2026-01-11 18:05:22', '2026-01-11 18:06:33', '2026-01-11 18:04:49', 2, NULL, 'TODOS', 0),
(9, 'SEIR-40829', 'PRUEBA GRADOS', 'FINALIZADA', 30, 5, 'ORDEN', 'FIJO', '2026-01-11 18:10:22', '2026-01-16 11:26:17', '2026-01-11 18:09:13', 2, NULL, 'TODOS', 0),
(10, 'SEIR-38579', 'PRUEBA FINAL 6', 'FINALIZADA', 30, 5, 'ORDEN', 'FIJO', '2026-01-11 18:17:24', '2026-01-16 11:26:15', '2026-01-11 18:16:55', 2, NULL, 'TODOS', 0),
(11, 'SEIR-66851', 'aaaaaaaaaaaaa', 'FINALIZADA', 300, 30, 'ORDEN', 'FIJO', '2026-01-11 18:53:36', '2026-01-11 18:53:41', '2026-01-11 18:50:57', 2, NULL, 'TODOS', 2),
(12, 'SEIR-52531', 'PRUEBA FINAL 7', 'FINALIZADA', 300, 30, 'ORDEN', 'FIJO', '2026-01-16 11:26:10', '2026-01-16 11:26:13', '2026-01-11 18:54:03', 2, NULL, 'TODOS', 2),
(13, 'SEIR-05315', '222222', 'FINALIZADA', 30, 10, 'ORDEN', 'FIJO', '2026-01-11 19:57:52', '2026-01-16 11:26:29', '2026-01-11 19:21:01', 2, NULL, '2', 2),
(14, 'SEIR-91816', 'prueba 100', 'FINALIZADA', 30, 5, 'ORDEN', 'FIJO', '2026-01-11 19:59:23', '2026-01-11 20:04:23', '2026-01-11 19:58:31', 2, NULL, '5', 5),
(15, 'SEIR-01977', 'VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV', 'CREADA', 30, 2, 'ORDEN', 'FIJO', NULL, NULL, '2026-01-16 11:43:48', 2, NULL, '5', 5),
(16, 'SEIR-36789', 'X', 'CREADA', 30, 5, 'ORDEN', 'FIJO', NULL, NULL, '2026-01-16 11:44:32', 2, NULL, '5', 5),
(22, 'SEIR-41455', 'EXAMEN A', 'FINALIZADA', 30, 5, 'ORDEN', 'FIJO', '2026-01-18 03:33:04', '2026-01-18 03:41:20', '2026-01-16 12:26:51', 9, NULL, '2', 2),
(23, 'SEIR-19943', 'gg', 'FINALIZADA', 30, 5, 'ORDEN', 'FIJO', '2026-01-18 03:33:01', '2026-01-18 03:41:16', '2026-01-16 17:54:16', 9, NULL, '4', 4),
(24, 'SEIR-56250', '5', 'FINALIZADA', 30, 5, 'ORDEN', 'FIJO', '2026-01-16 18:22:57', '2026-01-18 03:41:18', '2026-01-16 18:22:01', 9, NULL, '5', 5),
(25, 'SEIR-13789', 'CUANDO NACIO MESSI ?', 'FINALIZADA', 30, 30, 'ORDEN', 'FIJO', '2026-01-16 19:11:41', '2026-01-18 03:33:09', '2026-01-16 19:02:20', 9, NULL, '5', 5),
(26, 'SEIR-91945', 'pruebitas .com', 'FINALIZADA', 30, 30, 'ORDEN', 'FIJO', '2026-01-17 02:12:47', '2026-01-17 02:42:47', '2026-01-16 19:55:45', 2, NULL, '2', 2),
(27, 'SEIR-24809', 'xdxd', 'FINALIZADA', 30, 30, 'ORDEN', 'FIJO', '2026-01-16 19:57:42', '2026-01-16 20:27:42', '2026-01-16 19:56:57', 2, NULL, '5', 5),
(28, 'SEIR-68940', 'prueba imagen', 'FINALIZADA', 30, 30, 'ORDEN', 'FIJO', '2026-01-18 01:57:59', '2026-01-18 03:16:26', '2026-01-18 01:57:14', 9, NULL, '5', 5),
(33, 'SEIR-43846', 'PRUEBAS DE FILTRO 1', 'EN_CURSO', 30, 30, 'ALEATORIO', 'FIJO', '2026-01-18 17:46:37', '2026-01-18 18:16:37', '2026-01-18 03:41:59', 9, 1, '3', 3),
(34, 'SEIR-81171', 'prueba de tiempo', 'FINALIZADA', 30, 1, 'ORDEN', 'FIJO', '2026-01-18 03:49:28', '2026-01-18 03:50:28', '2026-01-18 03:48:42', 9, NULL, '1', 1),
(39, 'SEIR-69067', 'TODOS', 'FINALIZADA', 30, 5, 'ORDEN', 'FIJO', '2026-01-18 12:38:48', '2026-01-18 12:59:12', '2026-01-18 12:20:07', 9, NULL, '5', 5),
(40, 'SEIR-18575', 'PRUEBA 15', 'FINALIZADA', 30, 30, 'ALEATORIO', 'ALEATORIO', '2026-01-18 12:57:29', '2026-01-18 12:58:58', '2026-01-18 12:56:45', 9, 1, '5', 5),
(41, 'SEIR-70519', 'PRUEBA 16', 'FINALIZADA', 30, 30, 'ALEATORIO', 'FIJO', '2026-01-18 13:01:16', '2026-01-18 13:31:16', '2026-01-18 13:00:03', 9, 1, '5', 5),
(42, 'SEIR-50964', 'PRUEBA 17', 'FINALIZADA', 30, 1, 'ORDEN', 'FIJO', '2026-01-18 16:36:24', '2026-01-18 16:37:24', '2026-01-18 14:31:40', 9, 1, '5', 5),
(43, 'SEIR-81237', 'PRUEBA 18', 'FINALIZADA', 30, 30, 'ORDEN', 'FIJO', '2026-01-18 16:36:10', '2026-01-18 16:36:17', '2026-01-18 14:32:58', 9, 1, '5', 5),
(44, 'SEIR-01438', 'PRUEBA 19', 'FINALIZADA', 30, 30, 'ORDEN', 'FIJO', '2026-01-18 15:12:21', '2026-01-18 15:42:21', '2026-01-18 14:33:30', 9, 1, '5', 5),
(45, 'SEIR-75794', 'PRUEBA DE TIEMPO', 'FINALIZADA', 30, 1, 'ORDEN', 'FIJO', '2026-01-18 16:10:38', '2026-01-18 16:11:38', '2026-01-18 16:09:59', 9, NULL, '5', 5),
(46, 'SEIR-56276', '1', 'FINALIZADA', 30, 1, 'ORDEN', 'FIJO', '2026-01-18 16:29:52', '2026-01-18 16:30:52', '2026-01-18 16:29:39', 9, NULL, '', 0);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `partida_pregunta`
--

CREATE TABLE `partida_pregunta` (
  `id` int(11) NOT NULL,
  `id_partida` int(11) NOT NULL,
  `id_pregunta` int(11) NOT NULL,
  `orden` int(11) NOT NULL,
  `puntos` int(11) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `partida_pregunta`
--

INSERT INTO `partida_pregunta` (`id`, `id_partida`, `id_pregunta`, `orden`, `puntos`) VALUES
(7, 1, 4, 1, 1),
(8, 1, 2, 2, 1),
(9, 1, 3, 3, 1),
(16, 3, 6, 1, 1),
(17, 3, 5, 2, 1),
(20, 5, 10, 1, 1),
(21, 5, 9, 2, 1),
(24, 6, 10, 1, 1),
(25, 6, 9, 2, 1),
(26, 7, 10, 1, 1),
(27, 7, 9, 2, 1),
(28, 8, 10, 1, 1),
(29, 8, 9, 2, 1),
(32, 9, 11, 1, 1),
(33, 9, 12, 2, 1),
(35, 10, 12, 2, 1),
(36, 11, 13, 1, 1),
(37, 11, 14, 2, 1),
(38, 12, 15, 1, 1),
(39, 12, 16, 2, 1),
(44, 13, 18, 1, 1),
(45, 13, 17, 2, 1),
(46, 14, 16, 1, 1),
(47, 14, 15, 2, 1),
(48, 14, 14, 3, 1),
(49, 14, 13, 4, 1),
(57, 2, 21, 1, 1),
(58, 22, 22, 1, 1),
(59, 22, 4, 2, 1),
(60, 22, 3, 3, 1),
(61, 23, 23, 1, 1),
(62, 24, 23, 1, 1),
(63, 24, 20, 2, 1),
(64, 24, 8, 3, 1),
(70, 25, 7, 1, 1),
(71, 25, 6, 2, 1),
(72, 25, 8, 3, 1),
(73, 25, 20, 4, 1),
(74, 25, 23, 5, 1),
(75, 26, 18, 1, 1),
(76, 26, 17, 2, 1),
(77, 26, 16, 3, 1),
(78, 27, 16, 1, 1),
(79, 27, 15, 2, 1),
(80, 27, 14, 3, 1),
(81, 28, 25, 1, 1),
(82, 28, 24, 2, 1),
(87, 34, 23, 1, 1),
(88, 34, 21, 2, 1),
(89, 39, 27, 1, 4),
(90, 39, 25, 2, 4),
(91, 39, 24, 3, 4),
(92, 39, 23, 4, 4),
(93, 39, 20, 5, 4),
(94, 40, 27, 1, 20),
(95, 41, 27, 1, 20),
(96, 44, 30, 1, 10),
(97, 44, 29, 2, 10),
(98, 45, 29, 1, 10),
(99, 45, 30, 2, 10),
(100, 46, 29, 1, 1),
(101, 46, 30, 2, 1),
(102, 43, 30, 1, 1),
(103, 42, 30, 1, 1),
(104, 33, 28, 1, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `pregunta`
--

CREATE TABLE `pregunta` (
  `id_pregunta` int(11) NOT NULL,
  `enunciado` text NOT NULL,
  `imagen` varchar(255) DEFAULT NULL,
  `dificultad` varchar(20) NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `id_docente` int(11) NOT NULL,
  `id_curso` int(11) DEFAULT NULL,
  `grado` enum('1','2','3','4','5','TODOS') NOT NULL DEFAULT 'TODOS'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `pregunta`
--

INSERT INTO `pregunta` (`id_pregunta`, `enunciado`, `imagen`, `dificultad`, `activo`, `created_at`, `id_docente`, `id_curso`, `grado`) VALUES
(2, 'a', NULL, 'FACIL', 1, '2026-01-10 23:22:15', 9, NULL, '2'),
(3, 'e', NULL, 'FACIL', 1, '2026-01-10 23:22:29', 9, NULL, '2'),
(4, 'i', NULL, 'DIFICIL', 1, '2026-01-10 23:22:48', 9, NULL, '2'),
(5, 'que dia es mañaña ?', NULL, 'MEDIA', 1, '2026-01-10 23:23:27', 9, NULL, '5'),
(6, 'cuando nacio ce ere 7  ?', NULL, 'DIFICIL', 1, '2026-01-10 23:25:02', 9, NULL, '5'),
(7, 'EEEEEEEEEEEEEEEEEEEEEEEEEE', NULL, 'DIFICIL', 1, '2026-01-11 00:52:22', 9, NULL, '5'),
(8, 'WW', NULL, 'DIFICIL', 1, '2026-01-11 00:52:33', 9, NULL, '5'),
(9, 'a es a ?', NULL, 'DIFICIL', 0, '2026-01-11 17:45:01', 2, NULL, '5'),
(10, 'e', NULL, 'MEDIA', 0, '2026-01-11 17:45:12', 2, NULL, '5'),
(11, 'gaaaaaa', NULL, 'DIFICIL', 0, '2026-01-11 18:08:35', 2, NULL, '2'),
(12, 'XDDDDDDD', NULL, 'MEDIA', 0, '2026-01-11 18:08:58', 2, NULL, '2'),
(13, 'FFFFF', NULL, 'DIFICIL', 1, '2026-01-11 18:49:30', 2, NULL, 'TODOS'),
(14, 'a', NULL, 'MEDIA', 1, '2026-01-11 18:50:10', 2, NULL, 'TODOS'),
(15, 'VVVVVVVVVVVVVVVVVVVVVVVVVV', NULL, 'MEDIA', 1, '2026-01-11 18:53:17', 2, NULL, 'TODOS'),
(16, 'MMMMMMMMMMMMMMMM', NULL, 'DIFICIL', 1, '2026-01-11 18:53:27', 2, NULL, 'TODOS'),
(17, '1111111111111', NULL, 'DIFICIL', 1, '2026-01-11 19:20:23', 2, NULL, '2'),
(18, '222222222222222', NULL, 'DIFICIL', 0, '2026-01-11 19:20:38', 2, NULL, '2'),
(20, 'vvv', NULL, 'MEDIA', 1, '2026-01-16 11:45:37', 9, NULL, '5'),
(21, 'hhhhhhhhhhhhh', NULL, 'MEDIA', 1, '2026-01-16 11:45:52', 9, NULL, '1'),
(22, 'A', NULL, 'MEDIA', 1, '2026-01-16 12:26:39', 9, NULL, '2'),
(23, 'cuando murio santos ?', NULL, 'MEDIA', 1, '2026-01-16 17:53:58', 9, NULL, 'TODOS'),
(24, 'prueba', 'preg_696c8315b4ab12.20272023.png', 'MEDIA', 1, '2026-01-18 01:51:30', 9, NULL, '5'),
(25, 'prueba de imagen 1', 'preg_696c842461c512.86546796.png', 'MEDIA', 1, '2026-01-18 01:56:36', 9, 4, '5'),
(26, 'd', 'preg_696ca0d472eb23.29526702.png', 'FACIL', 1, '2026-01-18 03:59:00', 9, 3, '1'),
(27, 'MATEO', 'preg_696d1502720703.89889822.png', 'MEDIA', 1, '2026-01-18 12:14:42', 9, 1, '5'),
(28, '3RO', 'preg_696d1558565600.52626919.png', 'DIFICIL', 1, '2026-01-18 12:16:08', 9, 1, '3'),
(29, 'aaa', 'preg_696d353d9d0a16.92081340.png', 'DIFICIL', 1, '2026-01-18 14:32:13', 9, 1, '5'),
(30, 'bbbbbbbbb', 'preg_696d35550a0347.89348204.png', 'DIFICIL', 1, '2026-01-18 14:32:37', 9, 1, '5');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `respuesta`
--

CREATE TABLE `respuesta` (
  `id_respuesta` int(11) NOT NULL,
  `id_participante` int(11) NOT NULL,
  `id_partida_pregunta` int(11) NOT NULL,
  `id_alternativa` int(11) NOT NULL,
  `tiempo_respuesta` decimal(8,2) NOT NULL,
  `puntaje_obtenido` decimal(10,2) NOT NULL DEFAULT 0.00,
  `fecha_respuesta` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `respuesta`
--

INSERT INTO `respuesta` (`id_respuesta`, `id_participante`, `id_partida_pregunta`, `id_alternativa`, `tiempo_respuesta`, `puntaje_obtenido`, `fecha_respuesta`) VALUES
(13, 14, 26, 56, 174.00, 1.00, '2026-01-11 18:00:38'),
(14, 14, 27, 51, 160.00, 0.00, '2026-01-11 18:00:52'),
(15, 17, 28, 56, 243.00, 1.00, '2026-01-11 18:06:19'),
(17, 17, 29, 52, 238.00, 1.00, '2026-01-11 18:06:25'),
(18, 19, 32, 58, 294.00, 0.00, '2026-01-11 18:10:29'),
(19, 19, 33, 62, 289.00, 1.00, '2026-01-11 18:10:33'),
(20, 20, 32, 58, 85.00, 0.00, '2026-01-11 18:13:58'),
(23, 23, 32, 58, 11.00, 0.00, '2026-01-11 18:15:11'),
(25, 26, 35, 62, 294.00, 1.00, '2026-01-11 18:17:31'),
(26, 32, 44, 87, 597.00, 1.00, '2026-01-11 19:57:56'),
(27, 32, 45, 84, 590.00, 1.00, '2026-01-11 19:58:02'),
(28, 34, 46, 79, 294.00, 1.00, '2026-01-11 19:59:30'),
(29, 34, 47, 76, 291.00, 0.00, '2026-01-11 19:59:33'),
(30, 34, 48, 69, 288.00, 0.00, '2026-01-11 19:59:36'),
(31, 34, 49, 68, 280.00, 1.00, '2026-01-11 19:59:43'),
(32, 40, 70, 43, 975.00, 0.00, '2026-01-16 19:25:27'),
(33, 40, 71, 37, 851.00, 1.00, '2026-01-16 19:27:31'),
(34, 40, 72, 48, 847.00, 1.00, '2026-01-16 19:27:35'),
(35, 40, 73, 99, 843.00, 0.00, '2026-01-16 19:27:38'),
(36, 40, 74, 114, 839.00, 1.00, '2026-01-16 19:27:43'),
(37, 42, 78, 79, 1793.00, 1.00, '2026-01-16 19:57:50'),
(38, 42, 79, 76, 1785.00, 0.00, '2026-01-16 19:57:58'),
(39, 42, 80, 72, 1778.00, 1.00, '2026-01-16 19:58:04'),
(40, 44, 81, 126, 1770.00, 0.00, '2026-01-18 01:58:29'),
(41, 46, 89, 135, 259.00, 0.00, '2026-01-18 12:39:30'),
(42, 46, 90, 125, 254.00, 0.00, '2026-01-18 12:39:34'),
(43, 46, 91, 122, 245.00, 0.00, '2026-01-18 12:39:43'),
(44, 46, 92, 114, 243.00, 4.00, '2026-01-18 12:39:46'),
(45, 46, 93, 99, 240.00, 0.00, '2026-01-18 12:39:49'),
(46, 48, 94, 133, 1739.00, 0.00, '2026-01-18 12:58:30'),
(48, 50, 95, 134, 1773.00, 20.00, '2026-01-18 13:01:52'),
(49, 52, 96, 148, 1759.00, 10.00, '2026-01-18 15:13:06'),
(52, 52, 97, 142, 1746.00, 0.00, '2026-01-18 15:13:15');

--
-- Disparadores `respuesta`
--
DELIMITER $$
CREATE TRIGGER `trg_respuesta_puntaje_auto` BEFORE INSERT ON `respuesta` FOR EACH ROW BEGIN
  DECLARE v_correcta BOOLEAN;
  DECLARE v_puntos DECIMAL(10,2);

  SELECT a.es_correcta INTO v_correcta
  FROM alternativa a
  WHERE a.id_alternativa = NEW.id_alternativa;

  SELECT pp.puntos INTO v_puntos
  FROM partida_pregunta pp
  WHERE pp.id = NEW.id_partida_pregunta;

  SET NEW.puntaje_obtenido = IF(v_correcta = TRUE, IFNULL(v_puntos, 1), 0);
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `trg_respuesta_validar_alt` BEFORE INSERT ON `respuesta` FOR EACH ROW BEGIN
  DECLARE v_id_pregunta_pp INT;
  DECLARE v_id_pregunta_alt INT;

  SELECT id_pregunta INTO v_id_pregunta_pp
  FROM partida_pregunta
  WHERE id = NEW.id_partida_pregunta;

  SELECT id_pregunta INTO v_id_pregunta_alt
  FROM alternativa
  WHERE id_alternativa = NEW.id_alternativa;

  IF v_id_pregunta_pp IS NULL OR v_id_pregunta_alt IS NULL OR v_id_pregunta_pp <> v_id_pregunta_alt THEN
    SIGNAL SQLSTATE '45000'
      SET MESSAGE_TEXT = 'La alternativa no pertenece a la pregunta de esta partida.';
  END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuario`
--

CREATE TABLE `usuario` (
  `id_usuario` int(11) NOT NULL,
  `nombres` varchar(120) NOT NULL,
  `apellidos` varchar(120) NOT NULL,
  `username` varchar(60) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `estado` varchar(20) NOT NULL DEFAULT 'ACTIVO',
  `created_at` datetime NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `usuario`
--

INSERT INTO `usuario` (`id_usuario`, `nombres`, `apellidos`, `username`, `password_hash`, `estado`, `created_at`) VALUES
(2, 'Carlos', 'Docente', 'docente1', '$2y$10$vtkz1/FMz7NS6wi/vw3Cfen/yGawXM/SpWyI6Z8JNRyFEEoTTLfFG', 'ACTIVO', '2025-12-12 18:18:38'),
(3, 'ana', 'perez', '70000001', '$2y$10$FQJkvbGzHvwMh03kiFQYTu7D4TotFCxfVgsiXptCBnRCAoxYur5zm', 'ACTIVO', '2025-12-12 18:39:30'),
(4, 'Juan', 'perez', '70000002', '$2y$10$rH.hFJwS1aT36HRtt3c2.eS494ExW0M4zcAr7D5Fgo9yEOyQtTZYi', 'ACTIVO', '2025-12-12 18:40:12'),
(5, 'Jhon Antony', 'Rios Ccarapa', '72677254', '$2y$10$Nesx1GzDKVE.TaGAkN.JAuh8yA/Bd6Qh4OOizd.7j0lMy5q3Ecvn.', 'ACTIVO', '2026-01-07 19:34:14'),
(6, 'Ciro', 'Fuerte', '70000003', '$2y$10$eYDbVE5TEs52pENnz1EFH.VNq0HWU1a3ErLA1g8gxdQHVm9S8IuCa', 'ACTIVO', '2026-01-07 19:34:56'),
(7, 'Jhoel', 'Santos huaman', '70000004', '$2y$10$aaEvtni0vuofhjXgStdL.eznnQUNV2Uug5PWFp/SDAT.V6HhmMghq', 'ACTIVO', '2026-01-07 19:35:35'),
(8, 'Equipo ', 'SEIR', 'administrador', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'ACTIVO', '2026-01-09 19:44:09'),
(9, 'Pablo', 'Santos Avendaño', 'docente2', '$2y$10$ftkSI8JHAX5UUo8P7kG48eAWRupKE1AzOAN78ePdUi6WbgYJIMGiq', 'ACTIVO', '2026-01-10 12:55:58'),
(10, 'juancito', 'quispe', '70000005', '$2y$10$5tNogfAvxYqRhx42o7HH5.ofNIWTIAHeSeSINke/WGjSzqMC5updK', 'ACTIVO', '2026-01-10 23:01:16'),
(11, 'sofi', 'perez', '70000006', '$2y$10$fHx8q.lq6Hqq3OqOHCSaVOv6YZt1PQFjv9/XLgPGTyszNj1Ay3t9y', 'ACTIVO', '2026-01-11 17:52:46'),
(14, 'gaaaaaaaaaaaaaa', 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaa', '70000010', '$2y$10$Z0PfWyLAWwbgyZ70oAJU.OfNwBHkNyuTmdIXJExiI7qd.NEuFhb4O', 'ACTIVO', '2026-01-11 19:22:40');

-- --------------------------------------------------------

--
-- Estructura Stand-in para la vista `vw_ranking_partida`
-- (Véase abajo para la vista actual)
--
CREATE TABLE `vw_ranking_partida` (
`id_partida` int(11)
,`codigo_partida` varchar(30)
,`titulo` varchar(150)
,`id_participante` int(11)
,`alias` varchar(60)
,`nombres` varchar(120)
,`apellidos` varchar(120)
,`puntaje_total` decimal(32,2)
,`respuestas_registradas` bigint(21)
);

-- --------------------------------------------------------

--
-- Estructura para la vista `vw_ranking_partida`
--
DROP TABLE IF EXISTS `vw_ranking_partida`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vw_ranking_partida`  AS SELECT `p`.`id_partida` AS `id_partida`, `p`.`codigo` AS `codigo_partida`, `p`.`titulo` AS `titulo`, `par`.`id_participante` AS `id_participante`, `par`.`alias` AS `alias`, `u`.`nombres` AS `nombres`, `u`.`apellidos` AS `apellidos`, sum(`r`.`puntaje_obtenido`) AS `puntaje_total`, count(`r`.`id_respuesta`) AS `respuestas_registradas` FROM ((((`participante` `par` join `partida` `p` on(`p`.`id_partida` = `par`.`id_partida`)) join `estudiante` `e` on(`e`.`id_usuario` = `par`.`id_estudiante`)) join `usuario` `u` on(`u`.`id_usuario` = `e`.`id_usuario`)) left join `respuesta` `r` on(`r`.`id_participante` = `par`.`id_participante`)) GROUP BY `p`.`id_partida`, `p`.`codigo`, `p`.`titulo`, `par`.`id_participante`, `par`.`alias`, `u`.`nombres`, `u`.`apellidos` ;

--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `administrador`
--
ALTER TABLE `administrador`
  ADD PRIMARY KEY (`id_usuario`);

--
-- Indices de la tabla `alternativa`
--
ALTER TABLE `alternativa`
  ADD PRIMARY KEY (`id_alternativa`),
  ADD KEY `idx_alt_pregunta` (`id_pregunta`);

--
-- Indices de la tabla `computadora`
--
ALTER TABLE `computadora`
  ADD PRIMARY KEY (`id_computadora`),
  ADD UNIQUE KEY `uk_pc_codigo` (`codigo`),
  ADD UNIQUE KEY `uk_pc_ip` (`ip`),
  ADD KEY `fk_pc_admin` (`id_admin_supervisor`);

--
-- Indices de la tabla `configuracion`
--
ALTER TABLE `configuracion`
  ADD PRIMARY KEY (`id_config`),
  ADD UNIQUE KEY `uk_config_parametro` (`parametro`);

--
-- Indices de la tabla `curso`
--
ALTER TABLE `curso`
  ADD PRIMARY KEY (`id_curso`),
  ADD KEY `id_docente` (`id_docente`);

--
-- Indices de la tabla `docente`
--
ALTER TABLE `docente`
  ADD PRIMARY KEY (`id_usuario`);

--
-- Indices de la tabla `estudiante`
--
ALTER TABLE `estudiante`
  ADD PRIMARY KEY (`id_usuario`),
  ADD UNIQUE KEY `uk_estudiante_dni` (`dni`),
  ADD KEY `idx_estudiante_pc` (`id_computadora`);

--
-- Indices de la tabla `participante`
--
ALTER TABLE `participante`
  ADD PRIMARY KEY (`id_participante`),
  ADD UNIQUE KEY `uk_participante_partida_est` (`id_partida`,`id_estudiante`),
  ADD UNIQUE KEY `uk_participante_partida_alias` (`id_partida`,`alias`),
  ADD KEY `idx_participante_partida` (`id_partida`),
  ADD KEY `idx_participante_estudiante` (`id_estudiante`);

--
-- Indices de la tabla `partida`
--
ALTER TABLE `partida`
  ADD PRIMARY KEY (`id_partida`),
  ADD UNIQUE KEY `uk_partida_codigo` (`codigo`),
  ADD KEY `idx_partida_docente` (`id_docente`),
  ADD KEY `idx_partida_docente_estado` (`id_docente`,`estado`),
  ADD KEY `idx_partida_docente_curso` (`id_docente`,`id_curso`);

--
-- Indices de la tabla `partida_pregunta`
--
ALTER TABLE `partida_pregunta`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uk_pp_partida_pregunta` (`id_partida`,`id_pregunta`),
  ADD UNIQUE KEY `uk_pp_partida_orden` (`id_partida`,`orden`),
  ADD KEY `idx_pp_partida` (`id_partida`),
  ADD KEY `idx_pp_pregunta` (`id_pregunta`);

--
-- Indices de la tabla `pregunta`
--
ALTER TABLE `pregunta`
  ADD PRIMARY KEY (`id_pregunta`),
  ADD KEY `idx_pregunta_docente` (`id_docente`),
  ADD KEY `idx_pregunta_curso` (`id_curso`);

--
-- Indices de la tabla `respuesta`
--
ALTER TABLE `respuesta`
  ADD PRIMARY KEY (`id_respuesta`),
  ADD UNIQUE KEY `uk_resp_unica` (`id_participante`,`id_partida_pregunta`),
  ADD KEY `idx_resp_participante` (`id_participante`),
  ADD KEY `idx_resp_pp` (`id_partida_pregunta`),
  ADD KEY `idx_resp_alt` (`id_alternativa`);

--
-- Indices de la tabla `usuario`
--
ALTER TABLE `usuario`
  ADD PRIMARY KEY (`id_usuario`),
  ADD UNIQUE KEY `uk_usuario_username` (`username`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `alternativa`
--
ALTER TABLE `alternativa`
  MODIFY `id_alternativa` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=149;

--
-- AUTO_INCREMENT de la tabla `computadora`
--
ALTER TABLE `computadora`
  MODIFY `id_computadora` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de la tabla `configuracion`
--
ALTER TABLE `configuracion`
  MODIFY `id_config` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT de la tabla `curso`
--
ALTER TABLE `curso`
  MODIFY `id_curso` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT de la tabla `participante`
--
ALTER TABLE `participante`
  MODIFY `id_participante` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=53;

--
-- AUTO_INCREMENT de la tabla `partida`
--
ALTER TABLE `partida`
  MODIFY `id_partida` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=47;

--
-- AUTO_INCREMENT de la tabla `partida_pregunta`
--
ALTER TABLE `partida_pregunta`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=105;

--
-- AUTO_INCREMENT de la tabla `pregunta`
--
ALTER TABLE `pregunta`
  MODIFY `id_pregunta` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=31;

--
-- AUTO_INCREMENT de la tabla `respuesta`
--
ALTER TABLE `respuesta`
  MODIFY `id_respuesta` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=53;

--
-- AUTO_INCREMENT de la tabla `usuario`
--
ALTER TABLE `usuario`
  MODIFY `id_usuario` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `administrador`
--
ALTER TABLE `administrador`
  ADD CONSTRAINT `fk_admin_usuario` FOREIGN KEY (`id_usuario`) REFERENCES `usuario` (`id_usuario`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `alternativa`
--
ALTER TABLE `alternativa`
  ADD CONSTRAINT `fk_alt_pregunta` FOREIGN KEY (`id_pregunta`) REFERENCES `pregunta` (`id_pregunta`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `computadora`
--
ALTER TABLE `computadora`
  ADD CONSTRAINT `fk_pc_admin` FOREIGN KEY (`id_admin_supervisor`) REFERENCES `administrador` (`id_usuario`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Filtros para la tabla `curso`
--
ALTER TABLE `curso`
  ADD CONSTRAINT `fk_curso_docente` FOREIGN KEY (`id_docente`) REFERENCES `docente` (`id_usuario`) ON DELETE CASCADE;

--
-- Filtros para la tabla `docente`
--
ALTER TABLE `docente`
  ADD CONSTRAINT `fk_docente_usuario` FOREIGN KEY (`id_usuario`) REFERENCES `usuario` (`id_usuario`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `estudiante`
--
ALTER TABLE `estudiante`
  ADD CONSTRAINT `fk_estudiante_pc` FOREIGN KEY (`id_computadora`) REFERENCES `computadora` (`id_computadora`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_estudiante_usuario` FOREIGN KEY (`id_usuario`) REFERENCES `usuario` (`id_usuario`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `participante`
--
ALTER TABLE `participante`
  ADD CONSTRAINT `fk_participante_estudiante` FOREIGN KEY (`id_estudiante`) REFERENCES `estudiante` (`id_usuario`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_participante_partida` FOREIGN KEY (`id_partida`) REFERENCES `partida` (`id_partida`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `partida`
--
ALTER TABLE `partida`
  ADD CONSTRAINT `fk_partida_docente` FOREIGN KEY (`id_docente`) REFERENCES `docente` (`id_usuario`) ON UPDATE CASCADE;

--
-- Filtros para la tabla `partida_pregunta`
--
ALTER TABLE `partida_pregunta`
  ADD CONSTRAINT `fk_pp_partida` FOREIGN KEY (`id_partida`) REFERENCES `partida` (`id_partida`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_pp_pregunta` FOREIGN KEY (`id_pregunta`) REFERENCES `pregunta` (`id_pregunta`) ON UPDATE CASCADE;

--
-- Filtros para la tabla `pregunta`
--
ALTER TABLE `pregunta`
  ADD CONSTRAINT `fk_pregunta_curso` FOREIGN KEY (`id_curso`) REFERENCES `curso` (`id_curso`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_pregunta_docente` FOREIGN KEY (`id_docente`) REFERENCES `docente` (`id_usuario`) ON UPDATE CASCADE;

--
-- Filtros para la tabla `respuesta`
--
ALTER TABLE `respuesta`
  ADD CONSTRAINT `fk_resp_alt` FOREIGN KEY (`id_alternativa`) REFERENCES `alternativa` (`id_alternativa`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_resp_participante` FOREIGN KEY (`id_participante`) REFERENCES `participante` (`id_participante`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_resp_pp` FOREIGN KEY (`id_partida_pregunta`) REFERENCES `partida_pregunta` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
